/*
 * Decompiled with CFR 0.152.
 */
package ru.pinkgoosik.cosmetica.cosmetics;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.pinkgoosik.cosmetica.cosmetics.CosmeticModelPart;
import ru.pinkgoosik.cosmetica.render.cosmetics.CosmeticModelPartRenderer;
import ru.pinkgoosik.cosmetica.render.cosmetics.HeadSlimeRenderer;
import ru.pinkgoosik.cosmetica.render.cosmetics.KitsuneMaskRenderer;

public class Cosmetics {
    public static final List<CosmeticModelPart> COSMETICS = new ArrayList<CosmeticModelPart>();

    public static void init() {
        Cosmetics.add("slime", new HeadSlimeRenderer("slime"));
        Cosmetics.add("honey_slime", new HeadSlimeRenderer("honey_slime"));
        Cosmetics.add("sakura_slime", new HeadSlimeRenderer("sakura_slime"));
        Cosmetics.add("water_slime", new HeadSlimeRenderer("water_slime"));
        Cosmetics.add("kitsune_mask", new KitsuneMaskRenderer("kitsune_mask"));
        Cosmetics.add("blue_kitsune_mask", new KitsuneMaskRenderer("blue_kitsune_mask"));
    }

    private static void add(CosmeticModelPart cosmetic) {
        COSMETICS.add(cosmetic);
    }

    private static void add(String name, CosmeticModelPartRenderer renderer) {
        COSMETICS.add(new CosmeticModelPart(name, renderer));
    }

    public static Optional<CosmeticModelPart> getCosmeticModelPart(String name) {
        for (CosmeticModelPart item : COSMETICS) {
            if (!item.getName().equals(name)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }
}

